<?php
require "../config.php";
require "../includes/auth.php";

$courses = $pdo->query("SELECT * FROM courses ORDER BY id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
<title>Courses</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"/>
</head>
<body class="bg-dark text-white">

<div class="container mt-3">
<h3>📚 Manage Courses</h3>
<a href="add_course.php" class="btn btn-success mb-2">➕ Add Course</a>
<table class="table table-bordered text-white">
<tr><th>ID</th><th>Name</th><th>Price</th><th>QR</th><th>Action</th></tr>

<?php foreach($courses as $c): ?>
<tr>
<td><?=$c['id']?></td>
<td><?=$c['name']?></td>
<td>₹<?=$c['price']?></td>
<td><img src="<?=$c['payment_qr']?>" height="50"></td>
<td>
<a href="edit_course.php?id=<?=$c['id']?>" class="btn btn-info btn-sm">Edit</a>
<a href="delete_course.php?id=<?=$c['id']?>" class="btn btn-danger btn-sm">Delete</a>
</td>
</tr>
<?php endforeach; ?>
</table>
</div>
</body>
</html>
