<?php
require "../config.php";
require "../includes/auth.php";

// Counts (unchanged logic)
$total_users = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
$total_courses = $pdo->query("SELECT COUNT(*) FROM courses")->fetchColumn();
$total_orders = $pdo->query("SELECT COUNT(*) FROM orders")->fetchColumn();
$total_approved = $pdo->query("SELECT COUNT(*) FROM orders WHERE status='approved'")->fetchColumn();
$total_pending = $pdo->query("SELECT COUNT(*) FROM orders WHERE status='review' OR status='pending'")->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    
    <!-- Bootstrap 5.3 + Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    
    <style>
        :root {
            --bg-dark: #0d1117;
            --card-bg: #161b22;
            --border-color: #30363d;
            --text-muted: #8b949e;
            --primary-glow: #238636;
        }

        body {
            background: var(--bg-dark);
            color: #c9d1d9;
            min-height: 100vh;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
        }

        .navbar-custom {
            background: #21262d;
            border-bottom: 1px solid var(--border-color);
            flex-wrap: wrap;
            gap: 8px;
            padding: 1rem 0;
        }

        .card-stat {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        }

        .card-stat:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 20px rgba(0,0,0,0.5);
            border-color: var(--primary-glow);
        }

        .stat-number {
            font-size: 2.2rem;
            font-weight: 700;
            color: #58a6ff;
            margin-bottom: 0.5rem;
        }

        .stat-label {
            color: var(--text-muted);
            font-size: 0.95rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .icon-circle {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
            margin-bottom: 1rem;
            background: rgba(88, 166, 255, 0.15);
            color: #58a6ff;
        }

        .pending { background: rgba(255, 193, 7, 0.15) !important; color: #ffab00 !important; }
        .approved { background: rgba(34, 197, 94, 0.15) !important; color: #3fb950 !important; }

        h2 greet {
            font-weight: 600;
        }

        @media (max-width: 768px) {
            .navbar-custom .btn {
                font-size: 0.85rem;
                padding: 0.5rem 0.8rem;
            }
            .stat-number {
                font-size: 1.8rem;
            }
        }
    </style>
</head>
<body class="pb-5">

<div class="container-fluid px-4 py-4">
    <!-- Greeting -->
    <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-3">
        <h2 class="mb-0 greet">Welcome back, <strong><?= htmlspecialchars($_SESSION['admin_username']) ?></strong> 👋</h2>
        <a href="logout.php" class="btn btn-outline-danger btn-sm">
            <i class="bi bi-box-arrow-right"></i> Logout
        </a>
    </div>

    <!-- Navigation -->
    <div class="navbar-custom rounded-3 mb-5 p-3 shadow-sm">
        <div class="container-fluid">
            <div class="d-flex flex-wrap gap-2 justify-content-center justify-content-md-start">
                <a href="dashboard.php" class="btn btn-primary">
                    <i class="bi bi-speedometer2"></i> Dashboard
                </a>
                <a href="manage_institutes.php" class="btn btn-outline-info">
                    <i class="bi bi-building"></i> Institutes
                </a>
                <a href="manage_branches.php" class="btn btn-outline-info">
                    <i class="bi bi-geo-alt"></i> Branches
                </a>
                <a href="manage_courses.php" class="btn btn-outline-info">
                    <i class="bi bi-book"></i> Courses
                </a>
                <a href="orders.php" class="btn btn-warning text-dark">
                    <i class="bi bi-cart-check"></i> Orders
                </a>
                <a href="users.php" class="btn btn-outline-secondary">
                    <i class="bi bi-people"></i> Users
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="row g-4">
        <!-- Total Users -->
        <div class="col-6 col-md-4 col-lg-2">
            <div class="card-stat h-100 p-4 text-center">
                <div class="icon-circle mx-auto">
                    <i class="bi bi-people-fill"></i>
                </div>
                <div class="stat-number"><?= number_format($total_users) ?></div>
                <div class="stat-label">Total Users</div>
            </div>
        </div>

        <!-- Total Courses -->
        <div class="col-6 col-md-4 col-lg-2">
            <div class="card-stat h-100 p-4 text-center">
                <div class="icon-circle mx-auto">
                    <i class="bi bi-journal-text"></i>
                </div>
                <div class="stat-number"><?= number_format($total_courses) ?></div>
                <div class="stat-label">Courses</div>
            </div>
        </div>

        <!-- Total Orders -->
        <div class="col-6 col-md-4 col-lg-2">
            <div class="card-stat h-100 p-4 text-center">
                <div class="icon-circle mx-auto">
                    <i class="bi bi-cart4"></i>
                </div>
                <div class="stat-number"><?= number_format($total_orders) ?></div>
                <div class="stat-label">Total Orders</div>
            </div>
        </div>

        <!-- Pending / Review -->
        <div class="col-6 col-md-4 col-lg-2">
            <div class="card-stat h-100 p-4 text-center pending">
                <div class="icon-circle mx-auto">
                    <i class="bi bi-hourglass-split"></i>
                </div>
                <div class="stat-number"><?= number_format($total_pending) ?></div>
                <div class="stat-label">Pending Orders</div>
            </div>
        </div>

        <!-- Approved Orders -->
        <div class="col-6 col-md-4 col-lg-2">
            <div class="card-stat h-100 p-4 text-center approved">
                <div class="icon-circle mx-auto">
                    <i class="bi bi-check2-circle"></i>
                </div>
                <div class="stat-number"><?= number_format($total_approved) ?></div>
                <div class="stat-label">Approved</div>
            </div>
        </div>
    </div>

    <div class="text-center mt-5 text-muted small">
        &copy; <?= date('Y') ?> Admin Panel • All rights reserved.
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>