<?php
session_start();
require "../config.php";

// Simple admin login protection
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// ADD institute
if (isset($_POST['add'])) {
    $name = trim($_POST['name']);
    if ($name != "") {
        $stmt = $pdo->prepare("INSERT INTO institutes (name) VALUES (?)");
        $stmt->execute([$name]);
        $msg = "Institute added successfully.";
    }
}

// DELETE institute
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $pdo->prepare("DELETE FROM institutes WHERE id=?")->execute([$id]);
    header("Location: manage_institutes.php");
    exit;
}

// EDIT institute
if (isset($_POST['update'])) {
    $id = intval($_POST['id']);
    $name = trim($_POST['name']);
    if ($name != "") {
        $pdo->prepare("UPDATE institutes SET name=? WHERE id=?")
            ->execute([$name, $id]);
        $msg = "Institute updated successfully.";
    }
}

// Fetch all institutes
$rows = $pdo->query("SELECT * FROM institutes ORDER BY id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Institutes</title>

    <!-- BOOTSTRAP -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <!-- SAME DARK UI THEME AS OTHER PAGES -->
    <style>
        :root {
            --bg-dark: #0d1117;
            --card-bg: #161b22;
            --border-color: #30363d;
            --text-main: #e6edf3;
            --input-bg: #0d1117;
        }

        body {
            background: var(--bg-dark);
            color: var(--text-main);
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            padding-bottom: 50px;
        }

        .card-custom {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 14px;
            padding: 25px;
        }

        .form-control {
            background: var(--input-bg);
            border: 1px solid var(--border-color);
            color: var(--text-main);
            border-radius: 10px;
        }
        .form-control:focus {
            border-color: #58a6ff;
            box-shadow: 0 0 0 3px rgba(88,166,255,0.25);
        }

        .table th {
            background: #1f2731 !important;
            color: white;
        }

        .modal-content {
            background: #161b22;
            color: var(--text-main);
            border-radius: 12px;
        }

        .btn-outline-primary:hover { background: #0d6efd; }
        .btn-outline-danger:hover { background: #dc3545; }
    </style>
</head>

<body>

<div class="container py-5">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="bi bi-building text-primary"></i> Manage Institutes</h2>
        <a href="dashboard.php" class="btn btn-outline-secondary">
            <i class="bi bi-speedometer2"></i> Dashboard
        </a>
    </div>

    <!-- Add Institute -->
    <div class="card-custom mb-4">
        <h4 class="text-success"><i class="bi bi-plus-circle"></i> Add Institute</h4>

        <form method="POST" class="mt-3">
            <div class="row g-3">
                <div class="col-md-6">
                    <input type="text" name="name" class="form-control" placeholder="Institute Name" required>
                </div>
                <div class="col-md-3">
                    <button type="submit" name="add" class="btn btn-success w-100">
                        <i class="bi bi-plus-circle"></i> Add
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Institute List -->
    <div class="card-custom">
        <h5 class="mb-3"><i class="bi bi-list-ul"></i> Institutes (<?= count($rows) ?>)</h5>

        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Institute Name</th>
                    <th class="text-end">Actions</th>
                </tr>
                </thead>
                <tbody>

                <?php foreach ($rows as $r): ?>
                <tr>
                    <td><?= $r['id'] ?></td>
                    <td><?= htmlspecialchars($r['name']) ?></td>
                    <td class="text-end">

                        <!-- Edit Button -->
                        <button class="btn btn-outline-primary btn-sm"
                                onclick="editInstitute(<?= $r['id'] ?>, `<?= htmlspecialchars($r['name'], ENT_QUOTES) ?>`)">
                            <i class="bi bi-pencil"></i> Edit
                        </button>

                        <!-- Delete Button -->
                        <a href="?delete=<?= $r['id'] ?>"
                           class="btn btn-outline-danger btn-sm"
                           onclick="return confirm('Delete this institute?');">
                            <i class="bi bi-trash"></i> Delete
                        </a>

                    </td>
                </tr>
                <?php endforeach; ?>

                </tbody>
            </table>
        </div>

    </div>

</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header border-secondary">
                <h5 class="modal-title"><i class="bi bi-pencil-square"></i> Edit Institute</h5>
                <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>

            <form method="POST">
                <div class="modal-body">

                    <input type="hidden" id="edit_id" name="id">

                    <label class="form-label">Institute Name</label>
                    <input type="text" id="edit_name" name="name" class="form-control" required>

                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="update" class="btn btn-success">
                        <i class="bi bi-check2-all"></i> Update
                    </button>
                </div>
            </form>

        </div>
    </div>
</div>


<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
function editInstitute(id, name) {
    document.getElementById("edit_id").value = id;
    document.getElementById("edit_name").value = name;
    new bootstrap.Modal(document.getElementById('editModal')).show();
}
</script>

</body>
</html>
