<?php
require "../config.php";
require "../includes/auth.php"; // Admin Login Protection
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Users – Admin Panel</title>

    <!-- Bootstrap Grid Only (No styling interference) -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">

    <style>

        /* ===== GitHub Dark Theme ===== */
        body {
            background: #0d1117;
            color: #c9d1d9;
            margin: 0;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
        }

        /* FULL WIDTH CONTAINER */
        .main-container {
            max-width: 1500px;
            margin: auto;
            padding: 40px 20px;
        }

        /* CARD STYLE (GitHub dark) */
        .card-box {
            background: #161b22;
            border: 1px solid #30363d;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 25px;
        }

        /* TABLE */
        table {
            width: 100%;
            border-collapse: collapse;
            background: #0d1117 !important;
        }

        th {
            background: #21262d;
            color: #ffffff;
            padding: 12px;
            border-bottom: 1px solid #30363d;
            white-space: nowrap;
        }

        td {
            padding: 12px;
            border-bottom: 1px solid #30363d;
            color: #c9d1d9 !important;
            font-size: 15px;
        }

        tr:hover {
            background: #1c2128;
        }

        /* SEARCH BOX */
        .search-box input {
            background: #0d1117;
            border: 1px solid #30363d;
            color: #fff;
            padding: 10px;
            border-radius: 8px;
        }

        .search-box input:focus {
            outline: none;
            border-color: #58a6ff;
            box-shadow: 0 0 0 3px rgba(88,166,255,0.3);
        }

    </style>

</head>
<body>

<div class="main-container">
<a href="dashboard.php" 
   style="
        display:inline-block;
        padding:10px 18px;
        background:#21262d;
        border:1px solid #30363d;
        color:#c9d1d9;
        border-radius:8px;
        text-decoration:none;
        margin-bottom:20px;
        font-size:14px;
   ">
    ⬅ Back to Dashboard
</a>

    <div class="card-box">
        <h2 class="mb-4 fw-bold">👥 Registered Users</h2>

        <!-- Search Form -->
        <form method="GET" class="search-box mb-4">
            <input type="text" name="q" class="form-control"
                   placeholder="Search by name, username, or Telegram ID"
                   value="<?php echo isset($_GET['q']) ? htmlspecialchars($_GET['q']) : ''; ?>">
        </form>

        <?php
        // Search functionality
        $q = $_GET['q'] ?? '';

        if ($q) {
            $stmt = $pdo->prepare("
                SELECT * FROM users 
                WHERE telegram_id LIKE ? 
                   OR first_name LIKE ? 
                   OR username LIKE ?
                ORDER BY id DESC
            ");
            $stmt->execute(["%$q%", "%$q%", "%$q%"]);
        } else {
            $stmt = $pdo->query("SELECT * FROM users ORDER BY id DESC");
        }

        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
        ?>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Telegram ID</th>
                        <th>Name</th>
                        <th>Username</th>
                        <th>Joined On</th>
                    </tr>
                </thead>

                <tbody>
                <?php if (!$users): ?>
                    <tr>
                        <td colspan="5" class="text-center text-muted">No users found.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($users as $u): ?>
                        <tr>
                            <td><?php echo $u['id']; ?></td>
                            <td><?php echo $u['telegram_id']; ?></td>
                            <td><?php echo htmlspecialchars($u['first_name']); ?></td>
                            <td>@<?php echo htmlspecialchars($u['username']); ?></td>
                            <td><?php echo $u['created_at']; ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                </tbody>

            </table>
        </div>

    </div>

</div>

</body>
</html>
