<?php
require "config.php";

$token = $_GET['token'] ?? '';

if (!$token) {
    die("Invalid link.");
}

// Detect preview bots (Telegram, WhatsApp, Discord, Facebook, etc.)
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';

$bot_agents = [
    "TelegramBot",
    "WhatsApp",
    "facebookexternalhit",
    "Discordbot",
    "Slackbot",
    "Preview",
    "bot",
    "crawler",
    "spider",
    "Google",
    "Chrome-Lighthouse"
];

foreach ($bot_agents as $agent) {
    if (stripos($userAgent, $agent) !== false) {
        // Do NOT use the token
        die("Preview mode detected — link not activated.");
    }
}

// Fetch order with this token
$stmt = $pdo->prepare("SELECT * FROM orders WHERE access_token = ? LIMIT 1");
$stmt->execute([$token]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    die("Invalid or expired token.");
}

// Check if already used
if ($order["used"] == 1) {
    die("This link has already been used.");
}

// Get course group link
$stmt2 = $pdo->prepare("SELECT group_link FROM courses WHERE id = ?");
$stmt2->execute([$order["course_id"]]);
$course = $stmt2->fetch(PDO::FETCH_ASSOC);

// Mark token as used ONLY for real human clicks
$pdo->prepare("UPDATE orders SET used=1 WHERE id=?")->execute([$order["id"]]);

// Redirect to Telegram group
header("Location: ".$course["group_link"]);
exit;
?>
